/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import java.util.EnumMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.shared.RoomCategories;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.ArrowIcon;
import org.igoweb.util.swing.GuiUtil;

public class RoomRenderer
extends JComponent
implements ListCellRenderer<Object> {
    private final Font stdFont = UIManager.getFont("Label.font");
    private int fontH = UIManager.getInt("org.igoweb.fontH");
    private Icon rightIcon = new ArrowIcon(this.fontH, 1);
    private Icon closeIcon = new ArrowIcon(this.fontH, 2);
    private EnumMap<RoomCategories, JLabel> categories = new EnumMap(RoomCategories.class);
    private NumberFormat numFormat = NumberFormat.getInstance();
    private CRoom currentRoom = null;

    public RoomRenderer() {
        Font boldFont = this.stdFont.deriveFont(1);
        for (RoomCategories cat : RoomCategories.values()) {
            if (!cat.isVisible()) continue;
            JLabel label = new JLabel(Defs.getString(-897758079 + cat.ordinal()), this.rightIcon, 2);
            label.setHorizontalTextPosition(2);
            label.setFont(boldFont);
            label.setOpaque(true);
            this.categories.put(cat, label);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp;
        if (value instanceof RoomCategories) {
            comp = this.categories.get(value);
        } else {
            this.currentRoom = (CRoom)value;
            comp = this;
        }
        comp.setBackground(UIManager.getColor(((AList.InnerList)list).mouseUnder() == value ? "org.igoweb.selTextBg" : "org.igoweb.inputBg"));
        return comp;
    }

    public void setOpenCategory(RoomCategories category, boolean isOpen) {
        this.categories.get((Object)category).setIcon(isOpen ? this.closeIcon : this.rightIcon);
    }

    @Override
    public void paint(Graphics g) {
        if (this.currentRoom == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getBackground());
        int w = this.getWidth();
        g2d.fillRect(0, 0, w, this.getHeight());
        g2d.setFont(this.stdFont);
        g2d.setColor(UIManager.getColor("Label.foreground"));
        int y = g2d.getFontMetrics().getAscent();
        String nus = this.numFormat.format(this.currentRoom.getNumUsers());
        int numSize = (int)Math.ceil(g2d.getFont().getStringBounds(nus, g2d.getFontRenderContext()).getWidth());
        if (this.currentRoom.isPrivate()) {
            g2d.drawString(Defs.getString(2031923687), 0, y);
        }
        g2d.drawString(GuiUtil.makeStringFit(this.currentRoom.getName(), g2d, w - (4 + this.fontH * 3 + numSize)), this.fontH, y);
        g2d.drawString(nus, this.getSize().width - (2 + numSize) - this.fontH * 2, y);
        nus = this.numFormat.format(this.currentRoom.getNumGames());
        g2d.drawString(nus, w - 2 - (int)Math.ceil(g2d.getFont().getStringBounds(nus, g2d.getFontRenderContext()).getWidth()), y);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.fontH * 10, this.fontH);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

